/* jslint node: true */
'use strict';

/**
* Creates an instance of Line
*
* @constructor
* @this {Line}
* @param {Number} Maximum width this line can have
*/
function Line(maxWidth) {
	this.maxWidth = maxWidth;
	this.leadingCut = 0;
	this.trailingCut = 0;
	this.inlineWidths = 0;
	this.inlines = [];
}

Line.prototype.getAscenderHeight = function() {
	var y = 0;

	this.inlines.forEach(function(inline) {
		y = Math.max(y, inline.font.ascender / 1000 * inline.fontSize);
	});
	return y;
};

Line.prototype.hasEnoughSpaceForInline = function(inline) {
	if (this.inlines.length === 0) return true;
	if (this.newLineForced) return false;

	return this.inlineWidths + inline.width - this.leadingCut - (inline.trailingCut || 0) <= this.maxWidth;
};

Line.prototype.addInline = function(inline) {
	if (this.inlines.length === 0) {
		this.leadingCut = inline.leadingCut || 0;
	}
	this.trailingCut = inline.trailingCut || 0;

	inline.x = this.inlineWidths - this.leadingCut;

	this.inlines.push(inline);
	this.inlineWidths += inline.width;

	if (inline.lineEnd) {
		this.newLineForced = true;
	}
};

Line.prototype.getWidth = function() {
	return this.inlineWidths - this.leadingCut - this.trailingCut;
};

/**
* Returns line height
* @return {Number}
*/
Line.prototype.getHeight = function() {
	var max = 0;

	this.inlines.forEach(function(item) {
		max = Math.max(max, item.height || 0);
	});

	return max;
};

module.exports = Line;
