#include <stdio.h>

#define ROWS 8

/* Read array elements from the keyboard */
void read_input(int buffer[]) {
	int i;
	
	printf("Enter input\n");
	for (i = 0; i < ROWS; i++) {
		scanf("%d", &buffer[i]);
	}
}

/* Print array elements */
void print_array(int buffer[]) {
	int i;
	
	printf("Data:\n");
	for (i = 0; i < ROWS; i++) {
		printf("%d\n", buffer[i]);
	}
}

/* Swap the content of memory positions pointed to by num1 and num2 */
void swap (int *num1, int *num2) {
	int temp;
	temp = *num1;
	*num1 = *num2;
	*num2 = temp;
}

/* Perform a selection sort */
void selection_sort(int buffer[]) {
	int pos, min_pos, i;
	
	for (pos = 0; pos < ROWS-1; pos++) {
		printf("Looking for proper number for position %d. Looking at positions %d to %d\n", pos, pos+1, ROWS-1);
		min_pos = pos;
		for (i = pos+1; i < ROWS; i++) {
			if (buffer[i] < buffer[min_pos]) {
				min_pos = i;
			}
		}
		printf("Element in %d is the smallest. Putting it in pos %d\n", min_pos, pos);
		if (pos != min_pos) {
			swap(&buffer[pos], &buffer[min_pos]);
		}
	}
}

/* Perform a binary search in array buffer between lower and upper for
 * the element with value elem. Returns the position where the 
 * element was found, or -1 of the element was not in buffer */
int binary_search(int buffer[], int elem, unsigned int lower, unsigned int upper) {
	unsigned int middle;
	
	/* We finish (without finding the element) if the lower bound of
	 * the subarray we have to examine is greater than the upper bound */
	if (lower > upper)
		return(-1);
	
	/* Find the middle position */
	middle = (upper+lower) / 2;
	/* If you have found the element you are looking for
	 * in the middle position, return this position */
	if (buffer[middle] == elem)
		return(middle);

	/* If the element you are looking for is less than
	 * the element in the middle position, look at the
	 * lower half of the subarray you were looking at now */	
	if (buffer[middle] > elem)
		return(binary_search(buffer, elem, lower, middle-1));
	else /* Else look at the upper half */
		return(binary_search(buffer, elem, middle+1, upper));
}


int main (int argc, char *argv[]) {
	int data[ROWS];
	int search_elem, pos;
	
	read_input(data);
	print_array(data);

	selection_sort(data);

	print_array(data);
	
	printf("Element to look for:\n");
	scanf("%d", &search_elem);
	
	pos = binary_search(data, search_elem, 0, ROWS-1);
	
	if (pos != -1) {
		printf("Element %d found at position %d\n", search_elem, pos);
	}
	else {
		printf("Element %d not found\n", search_elem);
	}
	
	return(0);
}
