#include <stdio.h>

#define ROWS 18

/* Read array elements from the keyboard */
void read_input(int buffer[]) {
	int i;
	
	printf("Enter input\n");
	for (i = 0; i < ROWS; i++) {
		scanf("%d", &buffer[i]);
	}
}

/* Print array elements */
void print_array(int buffer[]) {
	int i;
	
	printf("Data:\n");
	for (i = 0; i < ROWS; i++) {
		printf("%d\n", buffer[i]);
	}
}

/* Swap the content of memory positions pointed to by num1 and num2 */
void swap (int *num1, int *num2) {
	int temp;
	temp = *num1;
	*num1 = *num2;
	*num2 = temp;
}


/* Perform (Lomuto) partitioning */
/* Select a random pivot element (for Lomuto the one at the upper
 * bound). Reorganize the elements in the array so that all elements 
 * with values lower than the pivot are to its left in the array
 * and all elements higher than the pivot to its right. Notice 
 * that the subarrays left and right of the pivot are still unsorted */
int partition (int buffer[], unsigned int low, unsigned int high) {
	int pivot, i, j;
	
	pivot = buffer[high];
    i = low;
	
    for (j = low; j < high; j++) {
		if (buffer[j] < pivot) {
			if (i != j) {
				swap(&buffer[i], &buffer[j]);
			}
			i = i+1;
		}
	}
    swap(&buffer[i], &buffer[high]);
    return(i);
}
    
    
/* Perform quick sort with Lomuto partitioning */
void quick_sort(int buffer[], int low, int high) {
	int pos;
	
    if (low < high) {
		/* Do the partitioning */
        pos = partition(buffer, low, high);
		/* Sort the subarray left of the pivot */
        quick_sort(buffer, low, pos - 1);
		/* Sort the subarray right of the pivot */
        quick_sort(buffer, pos + 1, high);
	}
}


int main (int argc, char *argv[]) {
	int data[ROWS];
	
	read_input(data);
	print_array(data);

	quick_sort(data, 0, ROWS-1);

	print_array(data);
		
	return(0);
}
