#include <stdio.h>
#include <string.h>

#define SIZE 10

/* Recursively reverse the string in 'src' and store it in 'dst'. len is 	*
 * the length of the string in 'src'.										*/
void rec_strreverse(const char *src, char *dst, int len) {
	/* If we have not reached the end of the string */
	if (*src != '\0') {
		*dst = *src; /* Copy the first character of 'src' to the first 	*
					  * position of 'dst'. 								*/
		rec_strreverse(src + 1, dst - 1, len); /* Repeat for the substring    *
												* starting from position 1 of *
												* 'src'. Copy it reversed in  *
												* 'dst' left from the chars	  *
												* you have already copied.	  */
	}
	else {
/*		*(dst + strlen(src)) = '\0';	THIS WILL NOT WORK. SINCE WE HAVE    *
										BUMPED THE SRC POINTER TO THE END    *
										OF THE STRING, STRLEN(SRC)->0.       *
										THAT'S WHY WE NEED THE LEN PARAMETER */

		/* In the previous step of the recursion we copied the last real char*
		 * of 'src' to position 0 of 'dst'. Then we performed another 		 *
		 * recursive call, for src+1, dst - 1. Therefore, dst now points one *
		 * position BEFORE the beginning of the array we use as destination. *
		 * We need to fix that!												 */
		dst = dst + 1;
		/* Now terminate the string in 'dst' with a '\0' after all characters*/
		*(dst + len) = '\0';
	}
}


int main(int argc, char *argv[]) {
	char orig[SIZE], copy[SIZE];
	char formatstr[15];

	sprintf(formatstr, "%%%ds", SIZE-1);

	scanf(formatstr, orig);
	rec_strreverse(orig, copy+strlen(orig)-1, strlen(orig));
  
	printf("Orig: %s, Copy: %s\n", orig, copy);
	return(0);
}
