#include <stdio.h>
#include <string.h>

#define NAME_LEN 20
#define FORMAT_LEN 10

struct student {
	char firstName[NAME_LEN];
	char lastName[NAME_LEN];
	unsigned int aem;
};

typedef struct student studentT;

/* Read the data of a student from input and store it to
 * the struct newStudent points to. Returns 0 on success, 1 on
 * failure (if the input was not as expected */
int read_student (studentT *newStudent) {
	char format_str[FORMAT_LEN];
	int result;
	
	snprintf(format_str, FORMAT_LEN, "%%%ds", NAME_LEN-1);
	
	result = scanf(format_str, newStudent->firstName);
	result += scanf(format_str, newStudent->lastName);
	result += scanf("%u", &(newStudent->aem));
/* The following lines are alternatives to the lines above. The 
 * alternative (not advisable) uses the combination of (), * and . */

/*	result = scanf(format_str, (*newStudent).firstName);
	result += scanf(format_str, (*newStudent).lastName); 
	result += scanf("%u", &((*newStudent).aem)); */
	/* Or even */
/*	result = scanf(format_str, &((*newStudent).firstName[0]));
	result += scanf(format_str, &((*newStudent).lastName[0])); 
	result += scanf("%u", &((*newStudent).aem)); */

	if (result != 3) {
		printf("Result was %d!\n", result);
		return(1);
	}
	
	return(0);
}


/* Return the size (in chars) of the first and last name */
int calcNameSize (studentT student) {
	unsigned int nameSize;
	
	nameSize = strlen(student.firstName) + strlen(student.lastName);

	return nameSize;
}


/* The program reads the data of a student and prints the number of
 * characters in first and last name, and the aem */
int main(int argc, char *argv[]) {
	studentT student;
	int res;
	
	printf("Enter student data: \n");
	res = read_student(&student);
	if (res != 0) {
		printf("Input error\n");
		return(1);
	}

	printf("Name size = %u characters, aem is %d\n", calcNameSize(student), student.aem);
	return 0;
}
