/* 
  Reads student data (first-, last-name, AEM) and stores them to a database 
  (actually a table). Then create an array of pointers, with each cell 
  corresponding to a letter of the alphabet. Each cell will point to the first
  entry in the "database" that stores a lastname starting with the letter 
  corresponding to the specific cell. Finally, print the 
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define FIRST_SIZE 20
#define LAST_SIZE 25
#define MAX_STUDENTS 10
#define FORMAT_LEN 10

/* The struct that corresponds to a student */
struct student_struct {
    int aem;
    char firstname[FIRST_SIZE];
    char lastname[LAST_SIZE];
};

/* And a synonym, abstract type definition for the struct */
typedef struct student_struct studentT;

/* Read student data from the keyboard. Store them to table.
   Stop when the table is full, or the user enters 1 as an aem.
   max_length is the size of the table. Returns the number of
   student entries introduced into the table 
*/
unsigned int read_students(studentT table[], int max_length) {
    int i;
    int input_aem;
    char format_first[FORMAT_LEN];
    char format_last[FORMAT_LEN];

    /* Different format strings for first and last, since 
       the lengths of the respective table fields in the struct 
       are different */
    snprintf(format_first, FORMAT_LEN, "%%%ds", FIRST_SIZE-1);
    snprintf(format_last, FORMAT_LEN, "%%%ds", LAST_SIZE-1);

    for (i = 0; i < max_length; i++) {
        printf("Enter student %d: ", i);
        scanf("%d", &input_aem);
        if (input_aem < 0) { /* Stop if an aem equal to -1 has been given */
            return(i);
        }
        table[i].aem = input_aem;
        scanf(format_first, table[i].firstname);
        scanf(format_last, table[i].lastname);
    }
    return(i);
}

/* Print all students in the database. table holds the database of students.
   num_students is the number of valid entries in table */
void print_students(studentT table[], int num_students) {
    int i;

    for (i = 0; i < num_students; i++) {
        printf("Student %d: %s %s %d\n", i, table[i].firstname, 
                                        table[i].lastname, table[i].aem);
    }
    return;
}

/* Find the first student in the database table with a lastname starting
   from each of the alphabet letters. Fill ptrs[] with the pointers to 
   the respective structs (each cell of ptrs corresponds to a letter) */
void find_first(studentT table[], int num_students, studentT *ptrs[]) {
    int i;
    char pos;

    /* Initialize the ptrs table */
    for (i = 0; i < 26; i++)
        ptrs[i] = NULL;

    /* For each letter */
    for (pos = 'A'; pos <= 'Z'; pos++) {
        /* Search the students table ... */
        for (i = 0; i < num_students; i++) {
            /* ... for a lastname starting from that letter */
            if (toupper(table[i].lastname[0]) == pos) {
                /* If found, store the pointer to the respective struct
                   in ptrs and move to the next letter */
                ptrs[pos - 'A'] = &table[i];
                break;
            }
        }
        /* If an entry with a lastname starting from a specific letter has not
           been found, the respective position in ptrs[] will remain NULL */
    }
}

/* For each of the alphabet letters, use the array of pointers to print the 
   first student in the table with a lastname starting from that letter. If
   for any of the letters no such student exists, print None */
void print_alpha(studentT *ptrs[]) {
    int i;

    for (i = 0; i < 26; i++) {
        printf("For letter %c: ", i+'A');
        if (ptrs[i] == NULL) {
            printf("None\n");
        }
        else {
            printf("%s %s %d\n", ptrs[i]->firstname, ptrs[i]->lastname, ptrs[i]->aem);
        }
    }
}

int main (int argc, char *argv[]) {
    studentT studentDB[MAX_STUDENTS];
    studentT *alphabet_ptrs[26];

    int num_students;

    /* Observe how functions with array parameters are called */
    /* Observe how we use a variable to store the return value
       of a function */
    num_students = read_students(studentDB, MAX_STUDENTS);
    print_students(studentDB, num_students);

    find_first(studentDB, num_students, alphabet_ptrs);
    print_alpha(alphabet_ptrs);

    return(0);
}