#include <stdio.h>
#include <math.h>

/* Reads 2 points in the 3D space. Stores their coordinates in a struct and
   calculates their eucledian distance */
   
struct point {
	double x;
	double y;
	double z;
};

typedef struct point pointT;

/* Implementation 1 of read_point. Returns struct */
/*
pointT read_point(){
	pointT input;

	printf("Enter x: ");
	scanf("%lf", &(input.x));
	printf("Enter y: ");
	scanf("%lf", &(input.y));
	printf("Enter z: ");
	scanf("%lf", &(input.z));
	
	return(input);
}
*/

/* Implementation 2 of read_point. Uses pointer argument to return data */
void read_point(pointT *input) {
	printf("Enter x: ");
	scanf("%lf", &(input->x));
	printf("Enter y: ");
	scanf("%lf", &(input->y));
	printf("Enter z: ");
	scanf("%lf", &(input->z));

	return;
}


double point_distance (pointT first_point, pointT second_point) {
	double res;

	res = pow(first_point.x - second_point.x, 2);
	res += pow(first_point.y - second_point.y, 2);
	res += pow(first_point.z - second_point.z, 2);

	res = sqrt(res);

	return(res);
}


int main (int argc, char *argv[]) {
	pointT point1, point2;

/* Uncomment if using implementation 1 of read_point() */
/*
	point1 = read_point();
	point2 = read_point();
*/

/* Uncomment if using implementation 2 of read_point() */
	read_point(&point1);
	read_point(&point2);

	printf("Point1: (%lf,%lf, %lf)\n", point1.x, point1.y, point1.z);
	printf("Point2: (%lf,%lf, %lf)\n", point2.x, point2.y, point2.z);
	printf("Distance: %lf\n", point_distance(point1, point2));

	return 0;
} 


















#if 0
struct point {
	double x;
	double y;
};

typedef struct point pointT;

int read_point (pointT *newPoint) {
	int result;
	double x, y;
	
	result = scanf("%lf, %lf", &x, &y);
/*	result = scanf("%lf, %lf", &newPoint->x, &newPoint->y); */
/*	result = scanf("%lf, %lf", &(*newPoint).x, &(*newPoint).y); */	

	if (result != 2)
		return(1);
	
	newPoint->x = x;
	/* (*newPoint).x = x; */
	newPoint->y = y;
	/* (*newPoint).y = y */
	
	return(0);
}


double calc_distance (pointT point1, pointT point2) {
	double distance;
	
	distance = sqrt(pow(point1.x - point2.x, 2) + pow(point1.y - point2.y, 2));
	return distance;
}

int main(int argc, char *argv[]) {
	pointT point1, point2;
	int res;
	
	printf("Enter point 1 coordinates: \n");
	res = read_point(&point1);
	if (res != 0) {
		printf("Input error\n");
		return(1);
	}

	printf("Enter point 2 coordinates: \n");
	res = read_point(&point2);
	if (res != 0) {
		printf("Input error\n");
		return(1);
	}


	printf("Distance = %lf\n", calc_distance(point1, point2));
	return 0;
}
#endif