#include <stdio.h>
#define MAX_STUDENTS 10
#define NAME_LEN 20

/* Stores student names in 2D array. Up to MAX_STUDENTS names are read, unless the user
 * enters a non positive AEM.
 * It is possible to print students in the order they were entered, or by AEM. 
 * Assume AEMs are unique and for N students they range between 1 and N (included) */ 
int main (int argc, char *argv[]) {
	char names[MAX_STUDENTS][NAME_LEN]; /* 2D array. Each row corresponds to a student (name) */
	char format_str[20];
	char *aem_to_name[MAX_STUDENTS] = {NULL};	/* Position i points to the row in names which 
												 * corresponds to the student with AEM i, if such a
												 * student exists, otherwise NULL */
	int student_count, i, aem;
	
	/* Create a more complex format specifier: %d, %19s for NAME_LEN=20 */
	sprintf(format_str, "%%d, %%%ds", NAME_LEN-1);
	
	printf("Enter AEM, Name (-1 as AEM to stop): ");
	for (student_count = 0; student_count < MAX_STUDENTS; student_count++) {
		/* Observe how we use the array name with ONE dimension as a parameter in scanf */
		scanf(format_str, &aem, names[student_count]);
		/* Stop condition */
		if (aem <= 0)
			break;
		aem_to_name[aem-1] = names[student_count];
	}
	
	
	printf("Printing by name:\n");
	for (i = 0; i < student_count; i++) {
		printf("%s\n", names[i]);
	}
	
	printf("Printing by aem:\n");
	for (i = 0; i < MAX_STUDENTS; i++){
		if (aem_to_name[i] != NULL) {
			printf("%d: %s\n", i+1, aem_to_name[i]);
		}
	}
	return(0);
}
