/* This is my first C program with pointers */
 #include <stdio.h>
int b;

int main(int argc, char *argv[]) {
	int a;
	int *a_ptr, *b_ptr;
	double real_num=1.234, *real_num_ptr;
	
	a = 0;
	b = 1;
	a_ptr = &a;
	b_ptr = &b;
	real_num_ptr = &real_num;
	printf("&a = %p, a = %d\n", &a, a);
	printf("a_ptr = %p, *a_ptr = %d\n", a_ptr, *a_ptr);
	printf("&b = %p, b = %d\n", &b, b);
	printf("b_ptr = %p, *b_ptr = %d\n", b_ptr, *b_ptr);
	/* Observe how addresses of local and global variables look */

	*b_ptr = 5;	
	printf("*b_ptr = %d, b = %d\n", *b_ptr, b);
	/* Observe that the value of b has changed to 5, because b_ptr was 
	   pointing to the memory region accommodating b */
	  
	/* Pointer arithmetic */
	b_ptr = b_ptr + 1;
	/* Now b_ptr does not point to "safe" memory */
	/* Observe how the address in b_ptr has 
	   increased by 4 (pointer arithmetic) */
	printf("b_ptr = %p\n", b_ptr);

	/* Let's do some pointer arithmetic with doubles */
	printf("Before: real_num_ptr = %p, ", real_num_ptr);
	real_num_ptr = real_num_ptr + 2;
	/* Now real_num_ptr does not point to "safe" memory */
	/* Observe how the address in real_num_ptr has 
	   increased by 16 (2*8) (pointer arithmetic) */
	printf("After: real_num_ptr = %p\n", real_num_ptr);

	/* Uncomment the following to experience a nice crash */
	/*
	b_ptr = NULL;
	*b_ptr = 5;
	*/
	
	return(0);
}
