#include <stdio.h>

/* Use defines for array size, as well as in every place in the
   program related to array size. This way you can move to larger
   datasets by making a single change in the program */
#define ROWS 2
#define COLS 3

int main(int argc, char *argv[]) { 
	int numbers[ROWS][COLS];
	int sum[ROWS];
	int i, j;

	/* Read a number of values and store them in array elements */
	printf("Enter array elements\n");
	for (i = 0; i < ROWS; i++) {
		printf("Enter elements of row %d\n", i);
		for (j = 0; j < COLS; j++) {
			scanf("%d", &numbers[i][j]);
		}
	}

	/* Print stored array elements */
	for (i = 0; i < ROWS; i++) {
		for (j = 0; j < COLS; j++) {
			printf("%d ", numbers[i][j]);
		}
		printf("\n");
	}

	/* Calculate the sum of array elements in each row. Notice the 
	   initialization of each element of sum to 0 before starting 
	   the accumulation for the respective row */
	
	for (i = 0; i < ROWS; i++) {
		sum[i] = 0;
		for (j = 0; j < COLS; j++) {
			sum[i] = sum[i] + numbers[i][j];
		}
	}

	/* Print the elements of sum */
	for (i = 0; i < ROWS; i++) {
		printf("sum[%d] = %d\n", i, sum[i]);
	}
	
	/* Notice that array elements are stored in concecutive 
	   places in memory. This is true at row boundaries as well. 
	   The first element of each row is positioned in the memory 
	   slot right after the position of the last element of the
	   previous row  */
	for (i = 0; i < ROWS; i++) {
		for (j = 0; j < COLS; j++) {
			printf("Address of element %d,%d is %p\n", i, j, &numbers[i][j]);
		}
	}
	return(0);
}
