#include <stdio.h>
#include <math.h>

int main (int argc, char *argv[]) {
    int input, res;
    double squareRoot;

    printf("Enter a non-negative integer: ");
    res = scanf("%d", &input);

    /* The order of comparisons in the complex logical expression matters!!! */
    /* If we inverse the order, we risk checking for input < 0 on an input   *
     * that was not an integer. With the correct order of comparisons, the   *
     * property of C to evaluate compound logical expressions only up to     *
     * the point the logical result can be derived - for example, if the 1st *
     * logical expression in an OR is TRUE, the 2nd one does not need to be  * 
     * evaluated - protects us from evaluating invalid input.                */
    if ((res != 1) || (input < 0)) {
        printf("Wrong input\n");
        /* The following return (from main) will terminate the program */
        /* The non-zero value may give a hint to the invoker of the    *
         * program that something was wrong */
        return 1;
    } 
    else {
        squareRoot = sqrt(input);
        printf("sqrt(%d) = %lf\n", input, squareRoot);
    }

    return 0;
}