#include <stdio.h>

/* A simple calculator. Reads <number1> <operator> <number2>, *
 * performs the respective operation and prints the result.   *
 * Error checking for the number and size of inputs, for the  *
 * validity of the operator and the validity of operands (in  *
 * division).                                                 */
int main (int argc, char *argv[]) {
	int val1, val2, retval, result;
	char operator;

	printf("Enter value operator value: ");
	retval = scanf("%d %c %d", &val1, &operator, &val2);
	if (retval != 3) {
		printf("Wrong input\n");
		return 1;
	}

	switch (operator) {
		case '+':
			result = val1 + val2;
			break;
		case '-':
			result = val1 - val2;
			break;
		case '*':
			result = val1 * val2;
			break;
		case '/':
			if (val2 == 0) {
				printf("Division by 0 not allowed\n");
				return 3;
			}
			result = val1 / val2;
			break;
		default:
			printf("Wrong operator\n");
			return 2;
	}

	printf("%d %c %d = %d\n", val1, operator, val2, result);
	return 0;
}
