function [ke] = stiffness_element_rectangle(domain)
%Calculates the [ke] stiffness matrix of a rectangular plate element. The 
%dimensions of [ke] are (12 x 12).
%Input
% domain: A struct containing the properties of the plate and mesh.
%Output
% ke : The stiffness matrix [ke] of the element 

% Domain properties
%%% Γράψτε εδώ %%%

% a,b,p
%%% Γράψτε εδώ %%%

% Coefficients of column 3
k33 = a^2*(80/p+16-16*v);
k43 = a*(-60/p-6+6*v);
k53 = 0;
%%% Γράψτε εδώ %%%

% Coefficients of column 2
k22 = b^2*(80*p+16-16*v);
%%% Γράψτε εδώ %%%

% Coefficients of column 1
k11 = 60*p+60/p+42-12*v;
%%% Γράψτε εδώ %%%

% Lower triangle of ke
%%% Γράψτε εδώ %%%

% Transpose-copy from lower triangle to upper triangle
for I = 1:12
    for J = I+1:12
        ke(I,J) = ke(J,I);
    end
end

% Finally multiply with D/(60*a*b)
%%% Γράψτε εδώ %%%
end

