function [Uf] = solve_linear_system(Kff,Ff)
%Solves the linear system [Kff]*{Uf}={Ff} resulting from the Finite Element 
%Method, after removing contrained freedom degrees.
%Input
% Kff : Submatrix of the global stiffness matrix [Kg], that contains only
%   rows and columns corresponding to FREE (not contrained) dofs.
% Ff : Subcector of the global force vector {Fg}, that contains only
%   entries corresponding to FREE (not contrained) dofs.
%Output
% Uf : Global vector with dimensions (n_free_dofs x 1), which contains the 
%   displacements (w, rotation-x or rotation-y) only at FREE (not 
%   constrained) freedom degrees of the structure. 

Uf = linsolve(Kff, Ff);

end

