function [] = plot_w(Ug, elements, domain, n_points)
%2D plot of the z-axis displacement of the plate at various points, which 
%are not necessary nodes.
%Input
% Ug : Matrix with dimensions (ndofs x 1) that contains the displacements
%   at all freedom degrees, after solving the linear system.
% elements: Matrix with dimensions (nelx*nely x 4). Each row corresponds to
%   1 element and contains its 4 nodes. Each node is represented by its 's'
%   number, where s = (j-1)*nx+i.
% domain: A struct containing the properties of the plate and mesh.
% n_points: The displacement w will be plotted at (n_points x n_points)
%   uniformly distributed points.

Lx = domain.Lx;
Ly = domain.Ly;

hx = Lx / (n_points-1);
hy = Ly / (n_points-1);

% Find the triplets
Xji = zeros(n_points,n_points);
Yji = zeros(n_points,n_points);
Wji = zeros(n_points,n_points);
for i=1:n_points
    for j=1:n_points
        x = (i-1) * hx;
        y = (j-1) * hy;
        w = calc_w(x, y, Ug, elements, domain);
        Xji(j,i) = x;
        Yji(j,i) = y;
        Wji(j,i) = w;
    end
end

% Plot
f = figure
surf(Xji,Yji,Wji);
title('w(x,y)')
xlabel('x')
ylabel('y')
zlabel('w')
f.CurrentAxes.YDir = 'Reverse'
f.CurrentAxes.ZDir = 'Reverse'

end