function [] = plot_Mx_parallel_to_x(y0, Ug, elements, domain, n_points)
%1D plot of the moment Mx of the plate along a line that is parallel to
%axis x.
%Input
% y0 : The y-coordinate of the points of the line.
% Ug : Matrix with dimensions (ndofs x 1) that contains the displacements
%   at all freedom degrees, after solving the linear system.
% elements: Matrix with dimensions (nelx*nely x 4). Each row corresponds to
%   1 element and contains its 4 nodes. Each node is represented by its 's'
%   number, where s = (j-1)*nx+i.
% domain: A struct containing the properties of the plate and mesh.
% n_points: The moment Mx will be plotted at 'n_points' uniformly 
%   distributed points.

Lx = domain.Lx;
h = Lx / (n_points-1);

% Store the x-coordinate and Mx of these points into vectors X, Mx.
X = zeros(n_points, 1);
Mx = zeros(n_points, 1);
for k=1:n_points
    x = (k-1) * h;;
    X(k, 1) = x;
    Mx(k, 1) = calc_Mx(x, y0, Ug, elements, domain);
end

% Plot the function
f = figure
plot(X, Mx);
title(['Mx(x,y=', num2str(y0), ')']);
xlabel('x')
ylabel('Mx')
f.CurrentAxes.YDir = 'Reverse'
end