function [Le] = matrix_Le_element(nodes_of_element, domain)
%Calculate the boolean matrix [Le] that maps the local freedom degress of
%an element to the global freedom degrees of the whole structure.
%Input
% nodes_of_element: Matrix with dimensions (1 x 4), containing the nodes of
%   the element. Each node is represented by its 's' number, 
%   where s = (j-1)*nx+i.
% domain: A struct containing the properties of the plate and mesh.
%Output
% Le : The boolean matrix [Le], with dimensions (ndofs_of_element x % ndofs). 
%   Each row corresponds to a local freedom degree at one of the element's 
%   nodes. Each column corresponds to a global freedom degree at one of the
%   structure's nodes. If the local and global freedom degrees are the same, 
%   then Le(i,j)=1. Otherwise Le(i,j)=0.

n_nodes = size(nodes_of_element, 2);
n_dofs_local = 3 * n_nodes;
n_dofs_global = domain.ndofs;
Le = zeros(n_dofs_local, n_dofs_global);

for k=1:n_nodes
    s = nodes_of_element(1, k);
    
    % Le(local, global) = 1, where global and local correspond to the same dof
    Le(3*(k-1)+1, 3*(s-1)+1) = 1; % w dof
    Le(3*(k-1)+2, 3*(s-1)+2) = 1; % theta_x dof
    Le(3*(k-1)+3, 3*(s-1)+3) = 1; % theta_y dof
end

Le = sparse(Le);
end
