function [Fg] = force_vector_global(elements, domain)
%Calculates the global {Fg} vector that contains the equivalent forces at
%all freedom degrees of the structure. The dimensions of {Fg} are 
%(ndofs x 1).
%Input
% elements: Matrix with dimensions (nelx*nely x 4). Each row corresponds to
%   1 element and contains its 4 nodes. Each node is represented by its 's'
%   number, where s = (j-1)*nx+i.
% domain: A struct containing the properties of the plate and mesh.
%Output
% Fg : The global force vector {Fg} of the structure

nelx = domain.nelx;
nely = domain.nely;
ndofs = domain.ndofs;

Fg = zeros(ndofs, 1);
for e = 1: nelx*nely
    nodes_of_element = elements(e, :);
    re = force_vector_element_rectangle(domain);
    Le = matrix_Le_element(nodes_of_element, domain);
    Fg = Fg + Le' * re;
end

end

