function [index2D] = find_node_with_xy(x0 , y0, domain)
%Finds the i,j indices of the node with x=x0 and y=y0.
%Input
% x0: The x-coordinate of the node
% y0: The y-coordinate of the node
% domain : struct containing the properties of the domain
%Output
% index2D : (1 x 2) matrix, containing the pair [i, j] of the node.

% Get the necessary properties
Lx =  domain.Lx;
Ly = domain.Ly;
nx = domain.nx;
ny = domain.ny;
dx = domain.dx;
dy = domain.dy;
tol = min(dx/2, dy/2);

% Check the coordinates
if (x0 <= -tol) || (x0 >= Lx+tol) || (y0 <= -tol) || (y0 >= Ly+tol)
    msg = ['node (', num2str(x0), ',', num2str(y0), ') is outside the plate'];
    throw(MException('find_node_with_xy:invalid_coordinates', msg))
end

% Find the (i,j) pair
index2D = [];
for i=1:nx
    for j=1:ny
        xi = (i-1)*dx;
        yj = (j-1)*dy;
        if (xi > x0-tol) && (xi < x0+tol) && (yj > y0-tol) && (yj < y0+tol)
            index2D = [index2D; [i, j]];
            return;
        end
    end
end

end

