function [node_coordinates, elements] = create_nodes_elements(domain)
% Creates the nodes and elements of the finite element mesh
%Input
% domain: A struct containing the properties of the plate and mesh.
%Output
% node_coordinates: Matrix with dimensions (nx*ny x 2) that contains the 
%   coordinates of the nodes. Each row corresponds to 1 node. Column 1 
%   contains the x-coordinates. Column 2 contains the y-coordinates.
% elements: Matrix with dimensions (nelx*nely x 4). Each row corresponds to
%   1 element and contains its 4 nodes. Each node is represented by its 's'
%   number, where s=(j-1)*nx+i.


% Read model properties
nx = domain.nx;
ny = domain.ny;
dx = domain.dx;
dy = domain.dy;
nelx = domain.nelx;
nely = domain.nely;

% Calculate coordinates of all nodes
node_coordinates = zeros(nx*ny, 2);
for i=1:nx
    for j=1:ny
        s = (j-1)*nx + i;
        x = (i-1)*dx;
        y = (j-1)*dy;
        node_coordinates(s,1) = x;
        node_coordinates(s,2) = y;
    end
end

% Array with nodes of elements
elements = zeros(nelx*nely, 4);
for i=1:nelx
    for j=1:nely
        sel = (j-1)*nelx + i;   %element (i,j)
        sn1 = (j-1)*nx + i;     %node (i,j)
        sn2 = (j-1)*nx + i+1;   %node (i+1,j)
        sn3 = j*nx + i+1;       %node (i+1,j+1)
        sn4 = j*nx + i;         %node (i,j+1)
        
        elements(sel, 1) = sn1;
        elements(sel, 2) = sn2;
        elements(sel, 3) = sn3;
        elements(sel, 4) = sn4;
    end
end

end

