function [domain, dof_supports] = create_domain(D, v, q, Lx, Ly, nx, ny)
%Helps the user to specify all properties of the domain (plate and mesh).
%Input
% D : Flexural stiffness of the plate
% v : Poisson's ratio
% q : The constant distributed load over the plate.
% Lx : The length of the plate along axis x
% Ly : The length of the plate along axis y
% nx : The number of nodes along axis x
% ny : The number of nodes along axis y
%Output
% domain: A struct containing the properties of the plate and mesh. It can  
%   be passed to other functions, but must not be changed. In addition to the 
%   input it also contains:
%   dx : The distance between 2 nodes along axis x. 
%   dy : The distance between 2 nodes along axis y.
%   nelx : The number of elements along axis x.
%   nely : The number of elements along axis y.
%   ndofs : The total number of degrees of freedom (dofs) from all nodes.  
%       Each node has 3 dofs: translation-z (w), rotation-x, rotation-y.
% dof_supports: A matrix with dimensions (ndofs x 1). Contains 1 for
%   constrained dofs and 0 for free dofs.

domain.D = D;
domain.v = v;
domain.q = q;
domain.Lx = Lx;
domain.Ly = Ly;
domain.nx = nx;
domain.ny = ny;

dx = Lx / (nx-1);
dy = Ly / (ny-1);
domain.dx = dx;
domain.dy = dy;

nelx = nx-1;
nely = ny-1;
domain.nelx = nelx;
domain.nely = nely;

ndofs = 3*nx*ny;
domain.ndofs = ndofs;

% There are 3 freedom degrees (w, theta_x, theta_y) for each node.
% Initially all freedom degrees are free.
dof_supports = zeros(3*nx*ny, 1);

end

