function [dof_supports] = apply_supports(support_text, nodes_index2D, ...
    dof_supports, domain)
%Applies 'fixed' or 'simple' supports at selected freedom degrees.
%Input
% support_text : What type of support to apply. Must be 'fixed' or 'simple'.
% nodes_index2D : Matrix with dimensions (n x 2) that contains the i,j
%   indices of the nodes. Each row is one node. Column 1 are the 
%   x-coordinates. Column 2 are the y-coordinates. 
% dof_supports: A matrix with dimensions (ndofs x 1). Contains 1 for
%   constrained dofs and 0 for free dofs.
%Output
% dof_supports : Updated version of the input "dof_supports" 

nx = domain.nx;
n_nodes = size(nodes_index2D, 1);

if strcmp(support_text, 'fixed')
    % 'fixed' support constrains 'w', 'theta_x' and 'theta_y'.
    for k=1:n_nodes
        i = nodes_index2D(k, 1);
        j = nodes_index2D(k, 2);
        s = (j-1)*nx+i;
        dof_supports(3*(s-1)+1) = 1; %w
        dof_supports(3*(s-1)+2) = 1; %theta_x
        dof_supports(3*(s-1)+3) = 1; %theta_y
    end
elseif strcmp(support_text, 'simple')
    % 'simple' support constrains 'w' only'
    for k=1:n_nodes
        i = nodes_index2D(k, 1);
        j = nodes_index2D(k, 2);
        s = (j-1)*nx+i;
        dof_supports(3*(s-1)+1) = 1; %w
    end
else
    msg = ['Support text must be "simple" or "fixed", but was', ...
        support_text];
    throw(MException('set_supports:invalid_support', msg))
end

end
