function [] = plot_My_parallel_to_x(y0, Wji, domain)
%1D plot of the moment My of the plate along a line that is parallel to
%axis x.
%Input
% y0 : The y-coordinate of the points of the line.
% Wji : Matrix with dimensions (nj x ni). Each entry j,i contains the 
%   z-displacement at node i,j. Entries j,i outside the plate contain NaN.
% domain : struct containing the properties of the domain.

% Get properties of the domain
Lx = domain.Lx;
h = domain.h;

% Find the (i, j) indices of the points parallel to x
index2D = find_nodes_with_y(y0, 0, Lx, domain); 
n_points = size(index2D, 1);

% Store the x-coordinate and My of these points into vectors X, My.
X = zeros(n_points, 1);
My = zeros(n_points, 1);
for k=1:n_points
    i = index2D(k, 1);
    j = index2D(k, 2);
    I = i-2;
    X(k, 1) = (I-1)*h;
    My(k, 1) = calc_My(i, j, Wji, domain);
end

% Plot the function
f = figure
plot(X, My);
title(['My(x,y=', num2str(y0), ')']);
xlabel('x')
ylabel('My')
f.CurrentAxes.YDir = 'Reverse'
