function [coefficients, rhs] = equations_corner_fixed(i, j, domain, qij)
%Creates FD equations for a corner node i,j with 'fixed' support
%Input
% i,j : The 2D indices of the node. Values i=1,2,ni-1,ni and j=1,2,nj-1,nj 
%   correspond to ghost nodes outside the plate.
% domain : struct containing the properties of the domain
% qij : the equivalent load at the node
%Output
% coefficients: matrix with as many rows as the equations for this node and
%   as many columns as the unknowns (which are as many as the nodes). 
%   This matrix contains the left-hand-side coefficients that are  
%   multiplied with the unknowns. 
% rhs: vector with as many rows as the equations for this node. This vector
%   contains the right-hand-side constants of the equations. 

% Get the properties needed in this function
ni = domain.ni;
nj = domain.nj;

% 3 equations per node
coefficients = zeros(3, ni*nj);
rhs = zeros(3,1);

% 1D index of each node on the stencil
s_c = (j-1)*ni+i;
s_n = (j-2)*ni+i;
s_s = j*ni+i;
s_w = (j-1)*ni+i-1;
s_e = (j-1)*ni+i+1;

% 1st equation: w = 0
coefficients(1, s_c) = 1;
rhs(1,1) = 0;

% 2nd equation: dw/dx = 0
coefficients(2,s_w) = -1;
coefficients(2,s_e) = 1;
rhs(2,1) = 0;

% 3rd equation: dw/dy = 0
coefficients(3,s_n) = -1;
coefficients(3,s_s) = 1;
rhs(3,1) = 0;


end

