function [func] = define_equations_corner(i, j, support)
%Defines a function handle that, when called later, will produce the 
%finite difference equations for a node i,j located on a 
%corner of the plate.
%Input
% i,j : The 2D indices of the node. Values i=1,2,ni-1,ni and j=1,2,nj-1,nj 
%   correspond to ghost nodes outside the plate.
% support : string that describes what type of support there is at node
%   i,j. It must be 'fixed', 'simple' or 'free'.
%Output
% func : the function handle that, when called by another function, will 
%   produce the finite difference equations for node i,j.

if strcmp(support,'fixed')
    func = @equations_corner_fixed;
elseif strcmp(support,'simple')
    func = @equations_corner_simple;
elseif strcmp(support,'free')
    msg = 'Free corners are not implemented yet';
    throw(MException(...
        'define_equations_func_corner:not_implemented', msg))
else
    msg = ['node (', num2str(i), ',', num2str(j), ...
        ') must be "simple", "fixed" or "free"'];
    throw(MException(...
        'define_equations_func_corner:invalid_support', msg))
end

end

