function [func] = define_equations_boundary(i, j, support, axis)
%Defines a function handle that, when called later, will produce the 
%finite difference equations for a node i,j located on the boundary
%perpendicular to axis "axis".
%Input
% i,j : The 2D indices of the node. Values i=1,2,ni-1,ni and j=1,2,nj-1,nj 
%   correspond to ghost nodes outside the plate.
% support : string that describes what type of support there is at node
%   i,j. It must be 'fixed', 'simple' or 'free'.
% axis : The axis perepndicular to the boundary. It must be 'x' or 'y'.
%Output
% func : the function handle that, when called by another function, will 
%   produce the finite difference equations for node i,j.


if strcmp(axis,'x')
    if strcmp(support,'simple')
        func = @equations_boundary_simple_x;
    elseif strcmp(support,'fixed')
        func = @equations_boundary_fixed_x;
    elseif strcmp(support,'free')
        func = @equations_boundary_free_x;
    else
        msg = ['node (', num2str(i), ',', num2str(j), ...
            ') must be "simple", "fixed" or "free"'];
        throw(MException('define_equations_boundary:invalid_support', msg))
    end
elseif strcmp(axis,'y')
    if strcmp(support,'simple')
        func = @equations_boundary_simple_y;
    elseif strcmp(support,'fixed')
        func = @equations_boundary_fixed_y;
    elseif strcmp(support,'free')
        func = @equations_boundary_free_y;
    else
        msg = ['node (', num2str(i), ',', num2str(j), ...
            ') must be "simple", "fixed" or "free"'];
        throw(MException('define_equations_boundary:invalid_support', msg))
    end
else
    msg = ['Invalid axis at node (', num2str(i), ',', num2str(j), ')'];
    throw(MException('define_equations_boundary:invalid_axis', msg));
end

end

