function [A,b] = create_all_equations(node_equations_funcs, domain, Qji)
%Creates the finite difference equations for all interior and boundary
%nodes of the plate.
%Input
% node_equations_funcs : Matrix with dimensions (nj x ni). Each entry j,i 
%   contains a function handle that, when called, will return the finite 
%   difference equations for node i,j. Entries j,i outside the plate  
%       contain 'g' instead of a function handle.
% domain : struct containing the properties of the domain.
% Qji : Matrix with dimensions (nj x ni). Each entry j,i contains the 
%       equivalent load at node i,j. Entries j,i outside the plate contain 
%       NaN.
%Output
% A: matrix containing the left-hand-side coefficients of the finite 
%   difference equations. Its dimensions are (n_equations x n_unknowns)
% b: vector containing the right-hand-side constants of the finite 
%   difference equations. Its dimensions are (n_equations x 1)

% Get the properties needed in this function
ni = domain.ni;
nj = domain.nj;

% Create the equations by looking at each node, one by one.
A = [];
b = [];
for i=3:ni-2
    for j=3:nj-2
        qij = Qji(j,i);
        func = node_equations_funcs{j,i};
        [coefficients, rhs] = func(i, j, domain, qij);
        A = [A; coefficients];
        b = [b; rhs];
    end
end


end

