function [w_max, x_max, y_max] = calc_w_max(Wji, domain)
%Calculates the maximum displacement along axis z and its location
%Input
% Wji : Matrix with dimensions (nj x ni). Each entry j,i contains the 
%   z-displacement at node i,j. Entries j,i outside the plate contain NaN.
% domain : struct containing the properties of the domain
%Output
% w_max : The maximum displacement along axis z
% x_max : The x-coordinate of the point where w=w_max
% y_max : The y-coordinate of the point where w=w_max

nx = domain.nx;
ny = domain.ny;
h = domain.h;

w_max = -Inf;
x_max = NaN;
y_max = NaN;
for I = 1:nx
    for J = 1:ny
        i = I+2;
        j = J+2;
        w = Wji(j,i);
        if (w > w_max)
            w_max = w;
            x_max = (I-1)*h;
            y_max = (J-1)*h;
    end
end
    
    
end

