function [Mx] = calc_Mx(i, j, Wji, domain)
%Calculates moment Mx at node i, j
%Input
% i,j : The 2D indices of the node. Values i=1,2,ni-1,ni and j=1,2,nj-1,nj 
%   correspond to ghost nodes outside the plate.
% Wji : Matrix with dimensions (nj x ni). Each entry j,i contains the 
%   z-displacement at node i,j. Entries j,i outside the plate contain NaN.
% domain : struct containing the properties of the domain
%Output
% Mx : The moment perpendicular to axis x

% Get the properties needed in this function
h = domain.h;
D = domain.D;
v = domain.v;

% Calculate the moment
sum = (-2-2*v)*Wji(j,i) + v*Wji(j-1,i) + v*Wji(j+1,i) + ...
    Wji(j,i-1) + Wji(j,i+1);
Mx = -D / h^2 * sum ;

end

