function [Qji] = apply_equivalent_loads_linear_x(q_start, q_end, domain)
%Calculates the equivalent nodal loads for distributed load q that changes
%linearly between the values q=q_start at x=0 and q=q_end at x=Lx.
%Input
% q_start : The value of the distributed load at x=0
% q_end : The value of the distributed load at x=Lx
% domain : struct containing the properties of the domain
%Output
% Qji : Matrix with dimensions (nj x ni). Each entry j,i contains the 
%       equivalent load at node i,j. Entries j,i outside the plate contain 
%       NaN

% Domain properties
ni = domain.ni;
nj = domain.nj;
nx = domain.nx;
ny = domain.ny;
Lx = domain.Lx;
h = domain.h;

%Equivalent nodal loads
Qji = NaN(nj, ni);
for I=1:nx
    for J=1:ny
        i = I+2;
        j = J+2;
        x = (Ι-1)*h;
        Qji(j,i) = q_start + (q_end-q_start) * x/Lx;
    end
end

end

