function [Kg] = stiffness_global(elements, domain)
%Calculates the global [Kg] stiffness matrix. The dimensions of [Kg] are 
%(ndofs x ndofs).
%Input
% elements: Matrix with dimensions (nelx*nely x 4). Each row corresponds to
%   1 element and contains its 4 nodes. Each node is represented by its 's'
%   number, where s = (j-1)*nx+i.
% domain: A struct containing the properties of the plate and mesh.
%Output
% Kg : The global stiffness matrix [Kg] of the structure.

nelx = domain.nelx;
nely = domain.nely;
ndofs = domain.ndofs;

Kg = zeros(ndofs, ndofs);
for e = 1: nelx*nely
    nodes_of_element = elements(e, :);
    ke = stiffness_element_rectangle(domain);
    Le = matrix_Le_element(nodes_of_element, domain);
    Kg = Kg + Le' * ke * Le;
end

end

