function [free_dofs, constrained_dofs] = separate_dofs_free_constrained(...
    dof_supports)
%Separates the freedom degrees of the structure into 2 groups: 
%   a) Constrained dofs, where a support is applied (e.g. simple or fixed)
%   b) Free dofs, where no support is applied and displacements can occur.
%Input
% dof_supports: A matrix with dimensions (ndofs x 1). Contains 1 for
%   constrained dofs and 0 for free dofs.
%Output
% free_dofs : Vector with dimensions (n_free_dofs x 1). Contains the global
%   number (e.g. row/column of [Kg], {Fg}, {Ug}) of all free dofs.
% constrained : Vector with dimensions (n_free_dofs x 1). Contains the global
%   number (e.g. row/column of [Kg], {Fg}, {Ug}) of all constrained dofs.

ndofs = size(dof_supports, 1);
free_dofs = [];
constrained_dofs = [];

for d=1:ndofs
    if dof_supports(d)==1
        constrained_dofs = [constrained_dofs; d];
    else
        free_dofs = [free_dofs; d];
    end
end

