close all; clear; clc;

% Describe the problem
D = 5000;
v = 0.3;
q = 10;
Lx = 3;
Ly = 2;
nx = 49;    % number of real nodes along axis x. E.g. 4, 7, 10, 16, 25
ny = 33;    % number of real nodes along axis y. E.g, 3, 5,  7, 11, 17

% Initialize the domain and mesh
[domain, dof_supports] = create_domain(D, v, q, Lx, Ly, nx, ny);
[node_coordinates, elements] = create_nodes_elements(domain);

% Apply supports to boundary and internal nodes
% Supports at edge x=0
nodes_index2D = find_nodes_with_x(0, 0, Ly, domain);
dof_supports = apply_supports('simple', nodes_index2D, dof_supports, domain);

% Supports at edge x=Lx: NONE!!!
%nodes_index2D = find_nodes_with_x(Lx, 0, Ly, domain);
%dof_supports = apply_supports('???', nodes_index2D, dof_supports, domain);

% Supports at edge y=0
nodes_index2D = find_nodes_with_y(0, 0, Lx, domain);
dof_supports = apply_supports('simple', nodes_index2D, dof_supports, domain);

% Supports at edge y=Ly
nodes_index2D = find_nodes_with_y(Ly, 0, Lx, domain);
dof_supports = apply_supports('simple', nodes_index2D, dof_supports, domain);

% Internal supports at x = Lx/2
nodes_index2D = find_nodes_with_x(Lx/2, 0, Ly, domain);
dof_supports = apply_supports('simple', nodes_index2D, dof_supports, domain);

% Internal supports at y = Ly/2
nodes_index2D = find_nodes_with_y(Ly/2, 0, Lx, domain);
dof_supports = apply_supports('simple', nodes_index2D, dof_supports, domain);

% Perform FEM analysis
Ug = perform_fem_analysis(node_coordinates, elements, dof_supports, domain);

% Calculate and plot results
n_points = 101;
plot_w_at_nodes(Ug, domain);
plot_w(Ug, elements, domain, n_points);
plot_Mx_parallel_to_x(Ly/4, Ug, elements, domain, n_points);
plot_My_parallel_to_x(Ly/4, Ug, elements, domain, n_points);
plot_Mxy_parallel_to_x(Ly/4, Ug, elements, domain, n_points);
plot_Mx_parallel_to_y(Lx/4, Ug, elements, domain, n_points);
plot_My_parallel_to_y(Lx/4, Ug, elements, domain, n_points);
plot_Mxy_parallel_to_y(Lx/4, Ug, elements, domain, n_points);