function [] = plot_w_at_nodes(Ug, domain)
%2D plot of the z-axis displacement of the plate only at nodes.
%Input
% Ug : Matrix with dimensions (ndofs x 1) that contains the displacements
%   at all freedom degrees, after solving the linear system.
% domain: A struct containing the properties of the plate and mesh.

dx = domain.dx;
dy = domain.dy;
nx = domain.nx;
ny = domain.ny;

% Find the triplets
Xji = zeros(ny,nx);
Yji = zeros(ny,nx);
Wji = zeros(ny,nx);
for i=1:nx
    for j=1:ny
        x = (i-1) * dx;
        y = (j-1) * dy;
        s = (j-1)*nx + i;
        w = Ug(3*(s-1)+1, 1);
        
        Xji(j,i) = x;
        Yji(j,i) = y;
        Wji(j,i) = w;
    end
end

% Plot
f = figure
surf(Xji,Yji,Wji);
title('w(x,y)')
xlabel('x')
ylabel('y')
zlabel('w')
f.CurrentAxes.YDir = 'Reverse'
f.CurrentAxes.ZDir = 'Reverse'

end