function [] = plot_My_parallel_to_y(x0, Ug, elements, domain, n_points)
%1D plot of the moment My of the plate along a line that is parallel to
%axis y.
%Input
% x0 : The x-coordinate of the points of the line.
% Ug : Matrix with dimensions (ndofs x 1) that contains the displacements
%   at all freedom degrees, after solving the linear system.
% elements: Matrix with dimensions (nelx*nely x 4). Each row corresponds to
%   1 element and contains its 4 nodes. Each node is represented by its 's'
%   number, where s = (j-1)*nx+i.
% domain: A struct containing the properties of the plate and mesh.
% n_points: The moment My will be plotted at 'n_points' uniformly 
%   distributed points.

Ly = domain.Ly;
h = Ly / (n_points-1);

% Store the x-coordinate and Mx of these points into vectors X, Mx.
Y = zeros(n_points, 1);
My = zeros(n_points, 1);
for k=1:n_points
    y = (k-1) * h;
    Y(k, 1) = y;
    My(k, 1) = calc_My(x0, y, Ug, elements, domain);
end

% Plot the function
f = figure
plot(Y, My);
title(['My(x=', num2str(x0), ',y)']);
xlabel('y')
ylabel('My')
f.CurrentAxes.YDir = 'Reverse'
end