function [Ug] = perform_fem_analysis(...
    node_coordinates, elements, dof_supports, domain)
%Performs analysis using the Finite Element Method to calculate the 
%global displacement vector {Ug} of the whole structure.
%Input
% node_coordinates: Matrix with dimensions (nx*ny x 2) that contains the 
%   coordinates of the nodes. Each row corresponds to 1 node. Column 1 
%   contains the x-coordinates. Column 2 contains the y-coordinates.
% elements: Matrix with dimensions (nelx*nely x 4). Each row corresponds to
%   1 element and contains its 4 nodes. Each node is represented by its 's'
%   number, where s=(j-1)*nx+i.
% domain: A struct containing the properties of the plate and mesh.
%Output
% Ug : Global vector with dimensions (ndofs x 1), which contains the 
%   displacements (w, rotation-x or rotation-y) at all freedom degrees of 
%   the structure.  

[free_dofs, constrained_dofs] = separate_dofs_free_constrained(...
    dof_supports);

Kg = stiffness_global(elements, domain);
Fg = force_vector_global(elements, domain);
Kff = Kg(free_dofs, free_dofs);
Ff = Fg(free_dofs);

Uf = solve_linear_system(Kff, Ff);

ndofs = domain.ndofs;
Ug = zeros(ndofs, 1);
Ug(free_dofs) = Uf;

end

