function [invA] = matrix_inverseA_element_rectangle(domain)
%Calculate the inverse of matrix 'A' needed to calculate the shape 
%functions of a rectangular plate element.
%Input
% domain: A struct containing the properties of the plate and mesh.
%Output
% invA : The inverse of matrix 'A' 

dx = domain.dx;
dy = domain.dy;
a = dx/2;
b = dy/2;

ab2  = a   * b^2;
ab3  = a   * b^3;
a2b  = a^2 * b;
a2b2 = a^2 * b^2;
a2b3 = a^2 * b^3;
a2b4 = a^2 * b^4;
a3b  = a^3 * b;
a3b2 = a^3 * b^2;
a3b3 = a^3 * b^3;
a3b4 = a^3 * b^4;
a4b2 = a^4 * b^2;
a4b3 = a^4 * b^3;

invA = 1/(8*a3b3)*[...
    2*a3b3, a3b4, a4b3, 2*a3b3, a3b4, -a4b3, ...
                            2*a3b3, -a3b4, -a4b3, 2*a3b3, -a3b4, a4b3;
    -3*a2b3, -a2b4, -a3b3, 3*a2b3, a2b4, -a3b3, ...
                            3*a2b3, -a2b4, -a3b3, -3*a2b3, a2b4, -a3b3;
    -3*a3b2, -a3b3, -a4b2, -3*a3b2, -a3b3, a4b2, ...
                            3*a3b2, -a3b3, -a4b2, 3*a3b2, -a3b3, a4b2;
    0, 0, -a2b3, 0, 0, a2b3, 0, 0, a2b3, 0, 0, -a2b3;
    4*a2b2, a2b3, a3b2, -4*a2b2, -a2b3, a3b2, ...
                            4*a2b2, -a2b3, -a3b2, -4*a2b2, a2b3, -a3b2;
    0, -a3b2, 0, 0, -a3b2, 0, 0, a3b2, 0, 0, a3b2, 0;
    b^3, 0, ab3, -b^3, 0, ab3, -b^3, 0, ab3, b^3, 0, ab3;
    0, 0, a2b2, 0, 0, -a2b2, 0, 0, a2b2, 0, 0, -a2b2;
    0, a2b2, 0, 0, -a2b2, 0, 0, a2b2, 0, 0, -a2b2, 0;
    a^3, a3b, 0, a^3, a3b, 0, -a^3, a3b, 0, -a^3, a3b, 0;
    -b^2, 0, -ab2, b^2, 0, -ab2, -b^2, 0, ab2, b^2, 0, ab2;
    -a^2, -a2b, 0, a^2, a2b, 0, -a^2, a2b, 0, a^2, -a2b, 0];

end

