function [d] = gather_element_displacements(Ug, e, elements, domain)
%Given the global displacement vector Ug, this function retrieves the 
%displacements at the freedom degrees of an element 'e'.
%Input
% Ug : Matrix with dimensions (ndofs x 1) that contains the displacements
%   at all freedom degrees, after solving the linear system.
% e : The element where the displacements will be found (e=1, 2, nelx*nely).
% elements: Matrix with dimensions (nelx*nely x 4). Each row corresponds to
%   1 element and contains its 4 nodes. Each node is represented by its 's'
%   number, where s = (j-1)*nx+i.
% domain: A struct containing the properties of the plate and mesh.
%Output
% d : Vector containing the displacements at the freedom degrees of the 
%   element. Its dimensions are (ndofs_of_element x 1). 
    
nodes_of_element = elements(e, :);
Le = matrix_Le_element(nodes_of_element, domain);
d = Le * Ug;

end

