function [w] = calc_w(x0, y0, Ug, elements, domain)
%Calculates the z-displacement w at a random point (x0, y0), which can be 
%a node or not.
%Input
% x0, y0 : The global coordinates of the point.
% Ug : Matrix with dimensions (ndofs x 1) that contains the displacements
%   at all freedom degrees, after solving the linear system.
% elements: Matrix with dimensions (nelx*nely x 4). Each row corresponds to
%   1 element and contains its 4 nodes. Each node is represented by its 's'
%   number, where s = (j-1)*nx+i.
% domain: A struct containing the properties of the plate and mesh.
%Output
% w : The z-displacement w 

% Find the element 'e' that contains (x0,y0). Also calculate the local
% coordinates (xloc, yloc) of the point (x0,y0), inside element 'e'
[e, xloc, yloc] = global_to_local_coordinates(x0, y0, domain);

% Find the vector 'd' that contains the displacements at dofs of element 'e'
d = gather_element_displacements(Ug, e, elements, domain);

% Inverse of matrix 'A' needed to calculate the shape functions of the
% element
invA = matrix_inverseA_element_rectangle(domain);

% Matrix 'matrix_x', with dimensions (1 x ndofs_of_element), needed to 
% calculate the shape functions
matrix_x = [1, xloc, yloc, xloc^2, xloc*yloc, yloc^2, ...
    xloc^3, xloc^2*yloc, xloc*yloc^2, yloc^3, xloc^3*yloc, xloc*yloc^3];

% Calculate the displacement w
w = matrix_x * invA * d;

end

