function [w_act] = solve_linear_system(A_act,b)
%Solves the linear system resulting from the Finite Difference Method
%Input
% A_act : square matrix containing the left-hand-side coefficients of the 
%   finite difference equations, but limited to the active unknowns only. 
%   Its dimensions are (n_equations x n_active_unknowns), 
%   where n_active_unknowns = n_equations.
% b : vector containing the right-hand-side constants of the finite 
%   difference equations. Its dimensions are (n_equations x 1)
%Output
% w_act : vector containing the solution of the linear system, but limited
%   only to active unknowns. For unknowns that correspond to real nodes,
%   w_act contains the displacements of those nodes along axis z.

w_act = linsolve(A_act, b);

end

