close all; clear; clc;

% Initialize the plate domain
D = 5000;
v = 0.3;
Lx = 3;
Ly = 2;
nx = 49; % number of real nodes along axis x
ny = 33; % number of real nodes along axis y
[domain, node_supports] = initialize_domain(D, v, Lx, Ly, nx, ny);


% Apply supports to boundary and internal nodes
% Supports at edge x=0
nodes_index2D = find_nodes_with_x(0, 0, Ly, domain);
node_supports = apply_supports('simple', nodes_index2D, node_supports);

% Supports at edge x=Lx
nodes_index2D = find_nodes_with_x(Lx, 0, Ly, domain);
node_supports = apply_supports('free', nodes_index2D, node_supports);

% Supports at edge y=0
nodes_index2D = find_nodes_with_y(0, 0, Lx, domain);
node_supports = apply_supports('simple', nodes_index2D, node_supports);

% Supports at edge y=Ly
nodes_index2D = find_nodes_with_y(Ly, 0, Lx, domain);
node_supports = apply_supports('simple', nodes_index2D, node_supports);

% Internal supports at x = Lx/2
nodes_index2D = find_nodes_with_x(Lx/2, 0, Ly, domain);
node_supports = apply_supports('simple', nodes_index2D, node_supports);

% Internal supports at y = Ly/2
nodes_index2D = find_nodes_with_y(Ly/2, 0, Lx, domain);
node_supports = apply_supports('simple', nodes_index2D, node_supports);


% Apply loads to nodes
qmin = 10;
qmax = 10;
Qji = apply_equivalent_loads_linear_x(qmin, qmax, domain);


% Perform analysis using the Finite Difference Method 
Wji = perform_fdm_analysis(node_supports, Qji, domain);

% Calculate and plot results
plot_w(Wji, domain);
plot_Mx_parallel_to_x(Ly/4, Wji, domain);
plot_My_parallel_to_x(Ly/4, Wji, domain);
plot_Mxy_parallel_to_x(Ly/4, Wji, domain);
plot_Mx_parallel_to_y(Lx/4, Wji, domain);
plot_My_parallel_to_y(Lx/4, Wji, domain);
plot_Mxy_parallel_to_y(Lx/4, Wji, domain);
[w_max, x_max, y_max] = calc_w_max(Wji, domain)