function [Wji] = reconstruct_w(w_act, active_w, domain)
%Reorganizes the solution vector (1D) of displacements as a matrix (2D).
%Input
% w_act : vector containing the solution of the linear system, but limited
%   only to active unknowns. For unknowns that correspond to real nodes,
%   w_act contains the displacements of those nodes along axis z.
% active_w : A vector containing the original unknowns that are active. 
%   Its dimensions are (1 x n_active_unknowns)
% domain : struct containing the properties of the domain.
% b : vector containing the right-hand-side constants of the finite 
%   difference equations. Its dimensions are (n_equations x 1)
%Output
% Wji : Matrix with dimensions (nj x ni). Each entry j,i contains the 
%   z-displacement at node i,j. Entries j,i outside the plate contain NaN.


ni = domain.ni;
nj = domain.nj;

Wji = NaN(nj, ni);
nS = length(w_act);
for S=1:nS
    s = active_w(S);
    
    numer = int32(s-1);
    denom = int32(ni);
    
    j = idivide(numer, denom) + 1;
    i = mod(numer, denom)+1;
    
    Wji(j,i) = w_act(S);
end

