function [] = plot_w(Wji, domain)
%2D plot of the z-axis displacement of the plate.
%Input
% Wji : Matrix with dimensions (nj x ni). Each entry j,i contains the 
%   z-displacement at node i,j. Entries j,i outside the plate contain NaN.
% domain : struct containing the properties of the domain.

ni = domain.ni;
nj = domain.nj;
h = domain.h;

% Find the triplets
Xji_internal = zeros(nj-4,ni-4);
Yji_internal = zeros(nj-4,ni-4);
Wji_internal = zeros(nj-4,ni-4);
for I=1:ni-4
    for J=1:nj-4
        i = I+2;
        j = J+2;
        Xji_internal(J,I) = (I-1) * h;
        Yji_internal(J,I) = (J-1) * h;
        Wji_internal(J,I) = Wji(j,i);
    end
end

% Plot
f = figure
surf(Xji_internal,Yji_internal,Wji_internal);
title('w(x,y)')
xlabel('x')
ylabel('y')
zlabel('w')
f.CurrentAxes.YDir = 'Reverse'
f.CurrentAxes.ZDir = 'Reverse'

end