function [] = plot_My_parallel_to_y(x0, Wji, domain)
%1D plot of the moment Mx of the plate along a line that is parallel to
%axis y.
%Input
% x0 : The yx-coordinate of the points of the line.
% Wji : Matrix with dimensions (nj x ni). Each entry j,i contains the 
%   z-displacement at node i,j. Entries j,i outside the plate contain NaN.
% domain : struct containing the properties of the domain.

% Get properties of the domain
Ly = domain.Ly;
h = domain.h;

% Find the (i, j) indices of the points parallel toyx
index2D = find_nodes_with_x(x0, 0, Ly, domain); 
n_points = size(index2D, 1);

% Store the y-coordinate and My of these points into vectors Y, My.
Y = zeros(n_points, 1);
My = zeros(n_points, 1);
for k=1:n_points
    i = index2D(k, 1);
    j = index2D(k, 2);
    J = j-2;
    Y(k, 1) = (J-1)*h;
    My(k, 1) = calc_My(i, j, Wji, domain);
end

% Plot the function
f = figure
plot(Y, My);
title(['My(x=', num2str(x0), ',y)']);
xlabel('y')
ylabel('My')
f.CurrentAxes.YDir = 'Reverse'
