function [] = plot_Mx_parallel_to_x(y0, Wji, domain)
%1D plot of the moment Mx of the plate along a line that is parallel to
%axis x.
%Input
% y0 : The y-coordinate of the points of the line.
% Wji : Matrix with dimensions (nj x ni). Each entry j,i contains the 
%   z-displacement at node i,j. Entries j,i outside the plate contain NaN.
% domain : struct containing the properties of the domain.

% Get properties of the domain
Lx = domain.Lx;
h = domain.h;

% Find the (i, j) indices of the points parallel to x
index2D = find_nodes_with_y(y0, 0, Lx, domain); 
n_points = size(index2D, 1);

% Store the x-coordinate and Mx of these points into vectors X, Mx.
X = zeros(n_points, 1);
Mx = zeros(n_points, 1);
for k=1:n_points
    i = index2D(k, 1);
    j = index2D(k, 2);
    I = i-2;
    X(k, 1) = (I-1)*h;
    Mx(k, 1) = calc_Mx(i, j, Wji, domain);
end

% Plot the function
f = figure
plot(X, Mx);
title(['Mx(x,y=', num2str(y0), ')']);
xlabel('x')
ylabel('Mx')
f.CurrentAxes.YDir = 'Reverse'
