function [Wji] = perform_fdm_analysis(node_supports, Qji, domain)
%Performs analysis using the Finite Difference Method to calculate the 
%displacements along axis z of the nodes of the plate.
%Input
% node_supports: A matrix with dimensions (nj x ni). Each entry of this 
%   matrix contains a string that describes the type of support of node j,i.
%   Valid values are 'free', 'simple', 'supported' (and 'g' for ghost nodes).
% Qji : Matrix with dimensions (nj x ni). Each entry j,i contains the 
%   equivalent load at node i,j. Entries j,i outside the plate contain NaN.
% domain : struct containing the properties of the domain.
%Output
% Wji : Matrix with dimensions (nj x ni). Each entry j,i contains the 
%   z-displacement at node i,j. Entries j,i outside the plate contain NaN.  

node_equations_funcs = define_all_node_equations(node_supports, domain);
[A,b] = create_all_equations(node_equations_funcs, domain, Qji);
[A_act, active_w, inactive_w] = keep_active_unknowns(A);
w_act = solve_linear_system(A_act, b);
Wji = reconstruct_w(w_act, active_w, domain);

end

