function [index2D] = find_node_with_xy(x0 , y0, domain)
%Finds the i,j indices of the node with x=x0 and y=y0.
%Input
% x0: The x-coordinate of the node
% y0: The y-coordinate of the node
% domain : struct containing the properties of the domain
%Output
% index2D : (1 x 2) matrix, containing the pair [i, j] of the node.

% Get the necessary properties
Lx =  domain.Lx;
Ly = domain.Ly;
nx = domain.nx;
ny = domain.ny;
h = domain.h;
tol = h / 2;

% Check the coordinates
if (x0 <= -tol) || (x0 >= Lx+tol) || (y0 <= -tol) || (y0 >= Ly+tol)
    msg = ['node (', num2str(x0), ',', num2str(y0), ') is outside the plate'];
    throw(MException('find_node_with_xy:invalid_coordinates', msg))
end

% Find the (i,j) pair
index2D = [];
for I=1:nx
    for J=1:ny
        xI = (I-1)*h;
        yJ = (J-1)*h;
        if (xI > x0-tol) && (xI < x0+tol) && (yJ > y0-tol) && (yJ < y0+tol)
            i = I + 2;
            j = J + 2;
            index2D = [index2D; [i, j]];
            return;
        end
    end
end

end

