function [func] = define_equations_internal(i, j, support)
%Defines a function handle that, when called later, will produce the 
%finite difference equations for a node i,j located in the 
%interior of the plate.
%Input
% i,j : The 2D indices of the node. Values i=1,2,ni-1,ni and j=1,2,nj-1,nj 
%   correspond to ghost nodes outside the plate.
% support : string that describes what type of support there is at node
%   i,j. It must be 'simple' or 'free'.
%Output
% func : the function handle that, when called by another function, will 
%   produce the finite difference equations for node i,j.

if strcmp(support,'free')
    func = @equations_internal_free;
elseif strcmp(support,'simple')
    func = @equations_internal_simple;
else
    msg = ['node (', num2str(i), ',', num2str(j), ...
        ') must be "free" or "simple"'];
    throw(MException(...
        'define_equations_func_internal:invalid_support', msg))
end

end

